VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3315
   ClientLeft      =   2805
   ClientTop       =   2070
   ClientWidth     =   5565
   LinkTopic       =   "Form1"
   ScaleHeight     =   3315
   ScaleWidth      =   5565
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   495
      Left            =   4440
      TabIndex        =   8
      Top             =   2400
      Width           =   735
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   600
      Width           =   615
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Read DI Chan 0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1200
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   600
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   4200
      Top             =   840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   4200
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "Device Number : "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2400
      TabIndex        =   9
      Top             =   360
      Width           =   1335
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   7
      Left            =   2880
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   6
      Left            =   3120
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   5
      Left            =   3360
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   4
      Left            =   3600
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Label Label6 
      Caption         =   "bit 7"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2760
      TabIndex        =   7
      Top             =   1920
      Width           =   495
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   3
      Left            =   3840
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Label Label5 
      Caption         =   "The DI lines have internal pull-up.  Pull them to GND to see change in state."
      Height          =   495
      Left            =   480
      TabIndex        =   6
      Top             =   2280
      Width           =   2895
   End
   Begin VB.Label Label2 
      Caption         =   "bit 0"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   4560
      TabIndex        =   5
      Top             =   1920
      Width           =   375
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   2
      Left            =   4080
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   1
      Left            =   4320
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Shape DIBits 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   0
      Left            =   4560
      Shape           =   3  'Circle
      Top             =   1680
      Width           =   135
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   3
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label lblResult 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   2640
      TabIndex        =   2
      Top             =   1200
      Width           =   735
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdExit_Click()
' unload the drivers for both objects
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End  ' exit the program
End Sub

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpcpio$" ' give Driver name to avoid Open DriverLINX dialog
.Req_device = devNum.ListIndex
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.Refresh
Form1.Caption = "Digital Input with " & LDD.Dev_Model
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()
SetupDISingleValue
SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' if no errors, then
If SR.Res_result = DL_NoErr Then
lblResult.Caption = SR.Res_Sta_ioValue
' .Res_Sta_ioValue property contains the single value result
' for 8bit digital port, the result will be between 0 and 255
' but KPCMCIA-AIxxx Series has only 4 DI lines so value will be 0 to 15
'
' do a logical AND with 2^i to determine the state of the ith bit
Dim i As Integer
For i = 0 To 7
If (SR.Res_Sta_ioValue And 2 ^ i) = 2 ^ i Then
DIBits(i).FillColor = vbGreen
Else
DIBits(i).FillColor = vbRed
End If
Next i

End If
End Sub

Private Sub Form_Load()
' load devNum with legal values
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it to first entry
devNum.ListIndex = 0
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupDISingleValue()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 0            ' is is channel 0, Port A
End With

End Sub


